unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, stCustomProtoComp, stSecComp, StreamSec.DSI.ArithComp,
  ExtCtrls;

type
  TfrmMain = class(TForm)
    stRSAKey1: TstRSAKey;
    Label1: TLabel;
    btnLoadFile: TButton;
    chbBase64: TCheckBox;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    edtPassword: TEdit;
    lblRSAPrivKeyStatus: TLabel;
    Label3: TLabel;
    edtStrToSign: TEdit;
    btnSign: TButton;
    memSignature: TMemo;
    rgStringEncoding: TRadioGroup;
    rgOutputEncoding: TRadioGroup;
    Label4: TLabel;
    cbDigestAlgorithm: TComboBox;
    rgSignEnc: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure btnLoadFileClick(Sender: TObject);
    procedure btnSignClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  TypInfo,
  StreamSec.DSI.Pkcs12,
  StreamSec.DSI.Pkcs8,
  StreamSec.DSI.PKTypes,
  StreamSec.DSI.IFC,
  stDERCoder, stPEMCoder, stGC, stSecUtils, stDERUtils,
  stSHA1,
  stSHA256,
  stSHA512,
  stWhirlpool,
  stARC2,
  stARC4,
  stDES,
  stAES,
  stDrbgAesCtr;

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
var
  lHA: tHashAlgorithm;
begin
  for lHA := Low(lHA) to High(lHA) do begin
    if FindHashClass(lHA) <> nil then
      cbDigestAlgorithm.Items.Add(GetEnumName(TypeInfo(tHashAlgorithm),Ord(lHA)));
  end;
end;

procedure TfrmMain.btnLoadFileClick(Sender: TObject);

  procedure LoadKey;
  var
    lF: iPFX;
    lPW: iSecretKey;
    lAS: iAuthenticatedSafe;
    lSC: iSafeContents;
    lPK: iPrivateKeyInfo;
    lIdx: Integer;
  begin
    stRSAKey1.Enabled := False;
    lF := tPFX.Create(gcamFirstAssignment);
    try
      if chbBase64.Checked then
        lF.GetStruct.LoadFromFile(OpenDialog1.FileName,fmtPEM)
      else
        lF.GetStruct.LoadFromFile(OpenDialog1.FileName,fmtDER);
      lPW := tSecretKey.CreateBMPStr(PWideChar(edtPassword.Text));
      lAS := lF.ExtractAuthSafeContent(lPW);
      if not Assigned(lAS) then Exit;
      lSC := lAS.ExtractAllSafeContents(lPW);
      if not Assigned(lSC) then Exit;
      for lIdx := 0 to lSC.ItemCount - 1 do begin
        case lSC.Items[lIdx].bagValue.Choice of
          pbKeyBag:
            lPK := lSC.Items[lIdx].bagValue.AsKeyBag;
          pbPkcs8ShroudedKeyBag:
            lPK := lSC.Items[lIdx].bagValue.AsPkcs8ShroudedKeyBag.DecryptPrivateKeyInfo(lPW);
        else
          lPK := nil;
        end;
        if Supports(lPK,iIFPrivateKey) then begin
          stRSAKey1.SetPrivateKey(lPK as iIFPrivateKey);
          stRSAKey1.Enabled := True;
        end;
      end;
    finally
      lF := nil;
    end;
  end;

begin
  if OpenDialog1.Execute then try
    LoadKey;
    if stRSAKey1.Enabled then
      lblRSAPrivKeyStatus.Caption := 'Private RSA key has been loaded'
    else
      lblRSAPrivKeyStatus.Caption := 'No private RSA key';
  finally
    tGCManager.GetDefault.Sweep;
  end;
end;

procedure TfrmMain.btnSignClick(Sender: TObject);
var
  lMsg: tBytes;
  lSign: AnsiString;
begin
  stRSAKey1.DigestAlgorithm := tHashAlgorithm(GetEnumValue(TypeInfo(tHashAlgorithm),cbDigestAlgorithm.Text));
  stRSAKey1.MGFHashAlgorithm := stRSAKey1.DigestAlgorithm;
  case rgStringEncoding.ItemIndex of
    0: lMsg := TEncoding.Default.GetBytes(edtStrToSign.Text);
    1: lMsg := TEncoding.UTF8.GetBytes(edtStrToSign.Text);
  end;
  case rgSignEnc.ItemIndex of
    0: stRSAKey1.SignEncoding := seEMSA3;
    1: stRSAKey1.SignEncoding := seEMSA4;
  end;
  case rgOutputEncoding.ItemIndex of
    0: lSign := stRSAKey1.GenerateSignature(BytesToOS(lMsg),sfHex);
    1: lSign := stRSAKey1.GenerateSignature(BytesToOS(lMsg),sfBase64);
  end;
  memSignature.Text := string(lSign);
end;

end.
